﻿/*

C#-Programm: bookshop (c)2015 by www.gossmann.at
C#-Übung: T3T3
V0.9 - last mod: 11052015
 
Aufgabenstellung (Zweck: WPF-Objekte kennen lernern und programmieren):
-----------------------------------------------------------------------

Angabe (c) DI Walter Taus FH Burgenland

T3T3 – Buchhandlung
 
Implementieren Sie für eine Buchhandlung eine TreeView zur Anzeige aller Bücher geordnet nach
Kategorien. Verwenden Sie dazu die Kategorien Krimi, Kochbuch, Reiseführer. Für die Bücher
verwenden Sie eine Klasse mit folgenden Instanzvariablen:
 ISBN Nummer (string)
 Titel (string)
 Autor (string)
 Erscheinungsjahr (int)
Wenn auf ein Buch in der TreeView geclickt wird, dann werden die Details des Buches in einem
modalen Dialog angezeigt.
-----------------------------------------------------------------------

Code basierend auf Beispiel T3T1 (c) DI Walter Taus (modifiziert)

T3T1 – Tree zur Weinauswahl
Implementieren Sie ein Window mit einer TreeView. Der Tree enthält als Hauptkategorien, Knoten
für Weißwein, Rosewein und Rotwein. Unterhalb dieser Hauptkategorien, sind einige Vertreter
dieser Weinkategorie aufgelistet. Der Tree wird dynamisch im Code behind (nicht XAML) aufgebaut.
Wenn ein Wein selektiert wird, dann wird in einem modalen Dialog die Bezeichnung und die Details
(Weingut, Jahrgang, …) des ausgewählten Weines angezeigt.

 */

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;

namespace T3T3
{
    /// <summary>
    /// Interaktionslogik für MainWindow.xaml
    /// </summary>
    public partial class MainWindow : Window
    {
        public MainWindow()
        {
            InitializeComponent();

            // Treeviewknoten anlegen

            TreeViewItem crimes    = new TreeViewItem();
            crimes.Header          =           "Krimis";
            TreeViewItem cooking   = new TreeViewItem();
            cooking.Header         =       "Kochbücher";
            TreeViewItem traveling = new TreeViewItem();
            traveling.Header       =      "Reiseführer";

            // Knoten implementieren

            primary.Items.Add(crimes);
            primary.Items.Add(cooking);
            primary.Items.Add(traveling);

            // 1. Unterknoten anlegen

            TreeViewItem crime1 = new TreeViewItem();
            TreeViewItem crime2 = new TreeViewItem();
            TreeViewItem crime3 = new TreeViewItem();
            TreeViewItem crime4 = new TreeViewItem();


/*          
            ******************************************************************************************************************************************************************
            ******************************************************************************************************************************************************************
            sämtliche Zahlen, Daten und Fakten sowie Namen sind frei erfunden - Ähnlichkeiten mit existierenden Personen oder Firmen sind rein zufällig und nicht beabsichtigt
            ******************************************************************************************************************************************************************
            ******************************************************************************************************************************************************************
*/

            // 1. Unterknoten mit Werten füllen
            
            crime1.Header = new book() { s_ISBN = "1234567890123", s_title = "Wenn es um Mitternacht aus der Puffn kracht...", s_author="Master of Crime", lg_pubyear=2014 };
            crimes.Items.Add(crime1);

            crime2.Header = new book() { s_ISBN = "3210987734235", s_title = "Sie kannte ihren Mörder", s_author = "Lolo Lieblich", lg_pubyear = 1987 };
            crimes.Items.Add(crime2);

            crime3.Header = new book() { s_ISBN = "1800471108155", s_title = "Das Massaker mit der Motorsäge am Acker", s_author = "Marianne Kramm", lg_pubyear = 2002 };
            crimes.Items.Add(crime3);

            crime4.Header = new book() { s_ISBN = "7778882293841", s_title = "Das Todesritual des Vergewaltigers", s_author = "Klaus Willi Windig", lg_pubyear = 1999 };
            crimes.Items.Add(crime4);

            // 2. Unterknoten anlegen

            TreeViewItem cooking1 = new TreeViewItem();
            TreeViewItem cooking2 = new TreeViewItem();
            TreeViewItem cooking3 = new TreeViewItem();
            TreeViewItem cooking4 = new TreeViewItem();

            // 2. Unterknoten mit Werten füllen
            
            cooking1.Header = new book() { s_ISBN = "6734588299012", s_title = "Gut, nahrhaft und günstig mit Insekten kochen", s_author = "Rüdiger Reibner", lg_pubyear = 2008 };
            cooking.Items.Add(cooking1);

            cooking2.Header = new book() { s_ISBN = "1245667443901", s_title = "Kalte Platten heiß zubereitet", s_author = "Marianne Leibner", lg_pubyear = 1990 };
            cooking.Items.Add(cooking2);

            cooking3.Header = new book() { s_ISBN = "7635456288321", s_title = "Maden, Würmer und Schlangen auf Dschungelart", s_author = "Tarzan", lg_pubyear = 2014 };
            cooking.Items.Add(cooking3);

            cooking4.Header = new book() { s_ISBN = "71234000879123", s_title = "Zaubertränke und Elexire für die moderne Hexe", s_author = "Heidrun Moser", lg_pubyear = 1947 };
            cooking.Items.Add(cooking4);
            
            // 3. Unterknoten anlegen

            TreeViewItem traveling1 = new TreeViewItem();
            TreeViewItem traveling2 = new TreeViewItem();
            TreeViewItem traveling3 = new TreeViewItem();
            TreeViewItem traveling4 = new TreeViewItem();

            // 3. Unterknoten mit Werten füllen

            traveling1.Header = new book() { s_ISBN = "1129800934527", s_title = "Nordkoreanische Touristenattraktionen", s_author = "Un Kum Sung", lg_pubyear = 2012 };
            traveling.Items.Add(traveling1);

            traveling2.Header = new book() { s_ISBN = "7772932209812", s_title = "Leistbarer Urlaub in Fukushima", s_author = "Henriette Klopp", lg_pubyear = 2013 };
            traveling.Items.Add(traveling2);

            traveling3.Header = new book() { s_ISBN = "1222234778453", s_title = "Reisetagebuch des Gewaltmarsches von Alaska nach Feuerland", s_author = "Claus-Reiner Grieß", lg_pubyear = 2014 };
            traveling.Items.Add(traveling3);

            traveling4.Header = new book() { s_ISBN = "9822134768643", s_title = "Auf den Spuren der Wikinger", s_author = "Karl Schwingler", lg_pubyear = 792 };
            traveling.Items.Add(traveling4);

        }
 
        // Handler für Auswahl
        private void OnSelect(object sender, RoutedPropertyChangedEventArgs<object> e)
        {
            TreeViewItem bookselection = e.NewValue as TreeViewItem                               ;
            object obj_book = bookselection.Header                                                ; // Objekt holen
            if (obj_book is book)                                                                   // war es ein Buch?
            {
                BookDetailDialog bdd = new BookDetailDialog                     (obj_book as book); // dann Daten dafür anzeigen lassen
                bdd.WindowStartupLocation = System.Windows.WindowStartupLocation.CenterOwner      ;
                bdd.ShowDialog                                                                  ();
            }
        }
    }
}